$(function () {
  $("#editWindow").draggable();
});

function display_dbsettings() {

  $.ajax({
    url: "webcore/get_content.php?display_dbsettings",
    success: function (data) {

      if (data == '')
        return false;

      document.getElementById('setup_page').innerHTML = data;

    }
  })

}

/* verifica connessione al db */
function launchDCV() {

  var ip = document.getElementById('ipaddress_db').value;
  var user = document.getElementById('username_db').value;
  var pass = document.getElementById('password_db').value;
  var name = document.getElementById('dbname_db').value;

  // $('#dcvCheck').fadeOut(100);

  $.post("webcore/get_content.php?executeDcv", {

    'ip': ip,
    'user': user,
    'pass': pass,
    'name': name

  }).done(function (data) {

    setTimeout(function () {
      document.getElementById('dcvCheck').innerHTML = data;
      $('#dcvCheck').fadeIn(100);
      $('#verificationComplete').fadeIn(100);

    }, 300);


  });

}



function RUNdatabaseCheck() {

  var ip = document.getElementById('ipaddress_db').value;
  var user = document.getElementById('username_db').value;
  var pass = document.getElementById('password_db').value;
  var name = document.getElementById('dbname_db').value;

  var prefix = '';
  var sharedPath = ''
  var username = '';
  var password = '';

  if (document.getElementById('db_prefix')) prefix = document.getElementById('db_prefix').value;
  if (document.getElementById('shared_folder')) sharedPath = document.getElementById('shared_folder').value;
  if (document.getElementById('username_login')) username = document.getElementById('username_login').value;
  if (document.getElementById('password1_login')) password = document.getElementById('password1_login').value



  var animation = bodymovin.loadAnimation({
    container: document.getElementById('saveConfig'),
    renderer: 'svg',
    loop: true,
    autoplay: true,
    path: 'svg/loadanimation/load.json'
  });
  $("#saveConfig").fadeIn(300);


  $.post("webcore/get_content.php?RUNdatabaseCheck", {

    'ip': ip,
    'user': user,
    'pass': pass,
    'name': name,
    'prefix': prefix,
    'sharedPath': sharedPath,
    'username': username,
    'password': password,

  }).done(function (data) {

    animation.destroy();

    if (data == 'installation_complete') {

      document.getElementById('saveConfig').onclick = function () {
        checkStatus()
      };
      document.getElementById('saveConfig').innerHTML = "<button style='width: 50%; height: 2vw; text-align: center; border-radius: 0.5vw; background-color: #80ff80; font-size: 0.8vw; text-transform:uppercase;'>" + "<?php echo $s_lan['WEBAPP']['MSG0224']; ?>" + "</button>";

    }

  });

}


/* form creazione db */
function RUNdbInstallation() {

  $.post("webcore/get_content.php?RUNdbInstallation", {

  }).done(function (data) {

    openEditWindow("WEBAPP INSTALLATION", data);
  });
}

/* controllo che i dati inseriti per la creazione del db siano giusti */
function checkConf() {

  var sharedPath = document.getElementById('shared_folder').value;
  var username = document.getElementById('username_login').value;
  var password = document.getElementById('password1_login').value;
  var checkpwd = document.getElementById('password2_login').value;

  $.post("webcore/get_content.php?saveSharedPath", {

    'sharedPath': sharedPath,

  }).done(function (data) {

    var step1 = false;
    var step2 = false;
    var step3 = false;

    if (data == 'error') {

      $('#shared_folder').animate({
        'color': 'red'
      }, {
        duration: 250
      }).delay(2000).animate({
        'color': '#000000'
      }, {
        duration: 250
      });
      $('#shared_folder_label').animate({
        'color': 'red'
      }, {
        duration: 250
      }).delay(2000).animate({
        'color': '#000000'
      }, {
        duration: 250
      });

      return false;

    } else {

      step1 = true;
      $('#shared_folder').animate({
        'color': '#61d43b'
      }, {
        duration: 250
      }).delay(2000).animate({
        'color': '#000000'
      }, {
        duration: 250
      });


      if (username == '' || username == null || username == undefined) {

        $('#username_login').animate({
          'color': 'red'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });
        $('#username_label').animate({
          'color': 'red'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });

        return false;

      } else {
        step2 = true;

        $('#username_login').animate({
          'color': '#61d43b'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });
      }

      if (password != checkpwd || password == '' || checkpwd == '') {

        $('#password1_label').animate({
          'color': 'red'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });
        $('#password1_login').animate({
          'color': 'red'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });

        $('#password2_label').animate({
          'color': 'red'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });
        $('#password2_login').animate({
          'color': 'red'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });

        return false;

      } else {
        step3 = true;

        $('#password1_login').animate({
          'color': '#61d43b'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });
        $('#password2_login').animate({
          'color': '#61d43b'
        }, {
          duration: 250
        }).delay(2000).animate({
          'color': '#000000'
        }, {
          duration: 250
        });
      }

      if (step1 == true && step2 == true && step3 == true) {
        RUNdatabaseCheck();
        closeWindow();
      }

    }

  });

}

/* se la config. è stata cambiata effettuare il logout */
function checkStatus() {

  $.post("webcore/get_content.php?checkStatus", {

  }).done(function (status) {

    if (status == 1) window.location.href = "login.php";
    else window.location.href = "index.php";

  })
}


function cleardcvCheck() {
  document.getElementById('dcvCheck').innerHTML = "";
}


function openEditWindow(title, content) {
  document.getElementById("editWindowTitle").innerHTML = title;
  document.getElementById("editWindowContent").innerHTML = content;
  $("#editWindow").fadeIn(200);
}

function closeWindow() {
  $("#editWindow").fadeOut(200);
  document.getElementById("editWindowTitPle").innerHTML = "";
  document.getElementById("editWindowContent").innerHTML = "";
  // unobscureLayer();
  $("#editWindow").css("height", "30vw");
}


/* -----------------------------------------------------------*/
// Update Licence 
function displayLicenseStatus() {
  console.log("Update License..");
  $.ajax({
    url: "get_content.php?displayLicenseStatus",
    success: function (data) {

      //console.log(data);
      document.getElementById('setup_license').innerHTML = data;

    }
  })
}

// Seleziona nuova licenza
function handleLicenseUpload() {
  $('#license-input').trigger('click');
}


  function downloadLicenseKey() {
    window.open('webcore/get_content.php?get2LicenseKey');
  }

function updateLicense() {
  $('#updatelicense_btn').prop("disabled", true);
  $.get("webcore/get_content.php?updateLicense").done(function (res) {
$('#updatelicense_btn').prop("disabled", false);
    if (res == true) {
       Swal.fire({
         position: "center",
         icon: "success",
         title: "License Updated",
         showConfirmButton: false,
         timer: 1000,
       });
       location.reload();
    } else {
         Swal.fire({
           position: "center",
           icon: "error",
           html: "<div style='font-weight:bold; text-transform:uppercase'>" + res + "</div>",
           showConfirmButton: true,
         });
   }
    });
 }
  
// Registra la nuova licenza
function submitLicenseFile(obj) {

  //console.log(obj.files[0]);
  let formdata = new FormData();
  formdata.append('license', obj.files[0]);

  $.ajax({
    type: 'post',
    url: 'get_content.php?registerLicense',
    contentType: false,
    processData: false,
    data: formdata,
    success: function (data) {
      alert('License Installed. Accept to restart Carambola.');
      location.reload();
    }
  });
}