let tableSetup = {}; // contiene il setup della vista in uso prima di cambiare
let listView = {};
let prevViewID = ''; // contiene il ID della vista in uso prima di cambiare
let colors = '';
let listAllColumns = []


$(document).ready(function () {
    loadTopbar();
});


$(window).on("resize", function () {});


function loadTopbar() {
    $.post('get_content.php?loadTopbar')
        .done(function (data) {
            let res = JSON.parse(data)
            document.getElementById("top-bar").innerHTML = res.top;
            loadTable();
        });
}

function loadTable() {
    var preradio = $("#idradio").find(":selected").attr("data-preradio"); // channel
    var dbtable = $("#database").val();

    document.getElementById('freeze').innerHTML = "Loading Table .....";
    var progress = setInterval(function () {
        if ($("#freeze").is(":hidden")) {
            $("#freeze").fadeIn('slow');
        } else {
            $("#freeze").fadeOut('slow');
        }
    }, 1500);

    $.post('get_content.php?getTableColumns', {
            dbtable: dbtable,
            preradio: preradio,
        })
        .done(function (data) {

            clearInterval(progress)

            let res = JSON.parse(data)
            let views = res.views
            let table_columns = res.columns
            let table_header = res.table_header
            colors = res.colors
            let sortName = 0
            let sortOrder = 'asc'
            let draw = 0;

            document.getElementById("mediamanager_header").innerHTML = table_header

            $("th").on("mousedown", function () {
                var table = $('#mediamanager_table').DataTable()
                if ($(this).css('border-left') === '1px solid rgb(255, 0, 0)') {
                    table.colReorder.disable();
                }

                if ($(this).text() == '') {
                    table.colReorder.disable();
                }
            });

            $("th").on("mouseup", function () {
                var dbtable = $("#database").val();
                var preradio = $("#idradio").find(":selected").attr("data-preradio"); // channel
                var table = $('#mediamanager_table').DataTable()

                table.colReorder.enable(true);

                let columns = [];
                $('#mediamanager_table thead tr th').each(function (i) {
                    var title = $(this).text();
                    if (title != "") columns[i] = listAllColumns[$(this).text()];
                });

                $.post('get_content.php?saveLayoutColumns', {
                        preradio: preradio,
                        dbtable: dbtable,
                        currentViewID: 2,
                        columns: JSON.stringify(columns),
                    })
                    .done(function (data) {});
            });


            listAllColumns = table_columns
            let columns = [];
            for (var e in table_columns) {
                e = table_columns[e]
                let col = {};
                col['data'] = e['data']
                col['title'] = e['title']
                col['name'] = e['name']
                col['visible'] = e['visible']
                col['className'] = e['className']

                switch (e['render']) {
                    case 'checkboxFormatter':
                        col['render'] = function (data, type) {
                            return checkboxFormatter(data)
                        }
                        break;
                    case 'timeFormatter':
                        col['render'] = function (data, type) {
                            return timeFormatter(data)
                        }
                        break;
                    case 'datetimeFormatter':
                        col['render'] = function (data, type) {
                            return datetimeFormatter(data)
                        }
                        break;
                    case 'nameFormatter':
                        col['render'] = function (data, type, row, index) {
                            return nameFormatter(data, type, row, index)
                        }
                        break;
                }
                columns.push(col)
            }

            let col = {};
            col['data'] = ''
            col['title'] = ''
            col['name'] = ''
            col['visible'] = true
            col['width'] = '100px'
            col['orderable'] = false
            columns.push(col)

            $('#view').empty();
            views.forEach(e => {
                $("#view").append(new Option(e['Description'], e['ID']));
                if (e['Enabled'] == 1) {
                    let viewSetup = JSON.parse(e['ViewSetup'])
                    sortName = viewSetup.params.sort
                    sortOrder = viewSetup.params.order
                    prevViewID = e['ID']
                    tableSetup['columns'] = viewSetup.columns
                    tableSetup['params'] = viewSetup.params
                    $('#view').val(e['ID'])
                }
            });

            var currentViewID = $('#view').val();

            var height = $('#table_div').height();
            $("#mediamanager_table").DataTable().clear().destroy();
            var table = $('#mediamanager_table').DataTable({
                scrollY: '75vh',
                scrollX: true,
                colReorder: true,
                processing: true,
                // autoWidth: false,
                colResize: {
                    isEnabled: true,
                    hoverClass: 'dt-colresizable-hover',
                    hasBoundCheck: true,
                    minBoundClass: 'dt-colresizable-bound-min',
                    maxBoundClass: 'dt-colresizable-bound-max',
                    saveState: true,
                    isResizable: function (column) {
                        return column.idx !== 2;
                    },
                    onResize: function (column) {
                        //console.log('...resizing...');
                    },
                    onResizeEnd: function (column, columns) {
                        //console.log('I have been resized!');
                    },
                    stateSaveCallback: function (settings, data) {
                        let stateStorageName = window.location.pathname + "/colResizeStateData";
                        localStorage.setItem(stateStorageName, JSON.stringify(data));
                    },
                    stateLoadCallback: function (settings) {
                        let stateStorageName = window.location.pathname + "/colResizeStateData",
                            data = localStorage.getItem(stateStorageName);
                        // console.log(JSON.parse(data))
                        return data != null ? JSON.parse(data) : null;
                    }
                },
                order: [
                    [sortName, sortOrder]
                ],

                lengthMenu: [50, 200, 500],
                pageLength: 50,
                responsive: true,
                processing: true,
                serverSide: true,
                ajax: {
                    type: "POST",
                    url: "sql/sql_mediamanager.php",
                    data: {
                        preradio: preradio,
                        dbtable: dbtable,
                        currentViewID: currentViewID,
                    },
                    dataType: "json",
                    //"dataSrc": "aaData",
                    dataSrc: function (json) {
                        $(".dataTables_scrollBody").addClass("scrollbar scrollbar-black");
                       // console.log(json.aaData)
                     json.aaData.forEach(e => {
                        //console.log(e.Play)
                     });
                        return json.aaData;
                    }
                },

                columns: columns,
                initComplete: function () {
                    $('#mediamanager_table_filter input').attr({
                        'class': 'input-report',
                        'data-toggle': 'tooltip',
                    })

                    $('#mediamanager_table_filter input').tooltip({
                        'trigger': 'focus',
                        'html': true,
                        'placement': 'right',
                        'title': 'The search will be made in the primary sort column Es.<br/> "a" Finds any values that have "a" in any position <br/> "a* " Finds any values that start with a <br/> " *a" Finds any values that end with a',
                    })
                },
                preDrawCallback: function (settings) {
                    $('#mediamanager_table_filter input').css('width', '20vw')
                },
                drawCallback: function (settings) {
                    if (draw == 0) {
                        let columns = tableSetup['columns'];
                        let order_1 = []
                        let order_2 = []
                        let i = 0;
                        table.columns().every(function () {
                            if (columns.some(columns => columns.title === this.header().innerHTML)) {
                                let index = columns.findIndex(columns => columns.title === this.header().innerHTML);
                                order_1[index] = i;
                            } else {
                                order_2.push(i);
                            }
                            i++;
                        })
                        let order = order_1.concat(order_2)
                        table.colReorder.order(order);
                    }
                    draw++;
                },
                createdRow: function (row, data, dataIndex) {

                    let bgcolor = 'rgb(255, 255, 255)'
                    let color = 'rgb(0, 0, 0)'

                    let table = dbtable.substring(1)

                    let vList = []
                    let maxList = 0

                    for (i = 0; i < colors.length; i++) {

                        /*if (colors[i].Channel != data.Channel && !(colors[i].Channel == "" || colors[i].Channel === null)) {
                            continue;
                        }*/

                        if (!((colors[i].TableName == "" || colors[i].TableName === null) || colors[i].TableName == table)) {
                            continue;
                        }

                        if (!((colors[i].GroupName == "" || colors[i].GroupName === null) || colors[i].GroupName == data.GroupName)) {
                            continue;
                        }

                        if (((colors[i].Category == "" || colors[i].Category === null) || colors[i].Category == data.Category)) {
                            maxList++;
                            vList.push(colors[i]);
                        }
                    }

                    //console.log(colors)
                    //console.log(vList)
                    for (i = 0; i < vList.length; i++) {
                        let TableName = table;

                        // Cerco se c'è : tabella, gruppo, categoria
                        if (vList[i].TableName == TableName && vList[i].GroupName == data.GroupName && vList[i].Category == data.Category) {
                            // console.log('1', data.ID, data.Category, vList[i].ID, vList[i].BackColor)
                            let backcolor = parseInt(vList[i].BackColor);
                            bgcolor = Hex(backcolor);

                            let forecolor = parseInt(vList[i].ForeColor);
                            color = Hex(forecolor);
                            break
                        }


                        //  Cerco se c' è: tabella, categoria
                        if (vList[i].TableName == TableName && vList[i].Category == data.Category && (vList[i].GroupName == '' || vList[i].GroupName === null)) {
                            // console.log('2', data.ID, data.Category, vList[i].ID, vList[i].BackColor)
                            let backcolor = parseInt(vList[i].BackColor);
                            bgcolor = Hex(backcolor);

                            let forecolor = parseInt(vList[i].ForeColor);
                            color = Hex(forecolor);
                            break
                        }


                        // Cerco se c'è : tabella, gruppo
                        if (vList[i].TableName == TableName && vList[i].GroupName == data.GroupName && (vList[i].Category == '' || vList[i].Category === null)) {
                            // console.log('3', data.ID, data.Category, vList[i].ID, vList[i].BackColor)
                            let backcolor = parseInt(vList[i].BackColor);
                            bgcolor = Hex(backcolor);

                            let forecolor = parseInt(vList[i].ForeColor);
                            color = Hex(forecolor);
                            break
                        }


                        // ' Cerco se c'è : tabella
                        if (vList[i].TableName == TableName && (vList[i].GroupName == '' || vList[i].GroupName === null) && (vList[i].Category == '' || vList[i].Category === null)) {
                            // console.log('4', data.ID, data.Category, vList[i].ID, vList[i].BackColor)
                            let backcolor = parseInt(vList[i].BackColor);
                            bgcolor = Hex(backcolor);

                            let forecolor = parseInt(vList[i].ForeColor);
                            color = Hex(forecolor);
                            break
                        }


                        // ' Cerco se c'è: gruppo, categoria (note)
                        if ((vList[i].TableName == '' || vList[i].TableName === null) && vList[i].Category == data.Category && vList[i].GroupName == data.GroupName) {
                            // console.log('5', data.ID, data.Category, vList[i].ID, vList[i].BackColor)
                            let backcolor = parseInt(vList[i].BackColor);
                            bgcolor = Hex(backcolor);

                            let forecolor = parseInt(vList[i].ForeColor);
                            color = Hex(forecolor);
                            break
                        }


                        // ' Cerco se c'è: categoria
                        if ((vList[i].TableName == '' || vList[i].TableName === null) && (vList[i].GroupName == '' || vList[i].GroupName === null) && vList[i].Category == data.Category) {
                            // console.log('6', data.ID, data.Category, vList[i].ID, vList[i].BackColor)
                            let backcolor = parseInt(vList[i].BackColor);
                            bgcolor = Hex(backcolor);

                            let forecolor = parseInt(vList[i].ForeColor);
                            color = Hex(forecolor);
                            break

                        }


                        // ' Cerco se c'è: gruppo
                        if ((vList[i].TableName == '' || vList[i].TableName === null) && (vList[i].Category == '' || vList[i].Category === null) && vList[i].GroupName == data.GroupName) {
                            // console.log('7', data.ID, data.Category, vList[i].ID, vList[i].BackColor)
                            let backcolor = parseInt(vList[i].BackColor);
                            bgcolor = Hex(backcolor);

                            let forecolor = parseInt(vList[i].ForeColor);
                            color = Hex(forecolor);
                            break

                        }
                    }

                    $(row).css({
                        'color': color,
                        'background-color': bgcolor
                    })
                },

            });

        })
}



function layoutColumns() {
    var dbtable = $("#database").val();
    var preradio = $("#idradio").find(":selected").attr("data-preradio"); // channel
    var currentViewID = $('#view').val();

    $.post('get_content.php?layoutColumns', {
            preradio: preradio,
            dbtable: dbtable,
            currentViewID: currentViewID
        })
        .done(function (data) {
            let res = JSON.parse(data);
            document.getElementById("enabled_columns").innerHTML = res.enabled_columns_html;
            document.getElementById("disabled_columns").innerHTML = res.disabled_columns_html;
            slist();
            $("#disabled_columns div").sort(Ascending_sort).appendTo('#disabled_columns');
            $('#layoutColumns').modal('show')
        });
}



function applyColumnsLayout() {
    let dbtable = $("#database").val();
    var preradio = $("#idradio").find(":selected").attr("data-preradio"); // channel
    var currentViewID = $('#view').val();
    var table = $('#mediamanager_table').DataTable()

    // colonne abilitate
    let enabled_columns = []
    $('#enabled_columns div').map(function () {
        let val = $(this).attr("value")
        enabled_columns.push(val)
    })

    let order_1 = []
    let order_2 = []
    let columns = [];
    var i = 0

    table.columns().visible(false)
    table.columns(122).visible(true); // ultima colonna

    table.columns().every(function () {

        if (enabled_columns.includes(this.header().innerHTML)) {
            table.columns(i).visible(true);
            let index = enabled_columns.findIndex((c) => c == this.header().innerHTML);
            order_1[index] = i;
            columns[index] = listAllColumns[this.header().innerHTML];
        } else {
            order_2.push(i);
        }
        i++;
    })

    let order = order_1.concat(order_2)

    table.colReorder.order(order);

    $.post('get_content.php?saveLayoutColumns', {
            preradio: preradio,
            dbtable: dbtable,
            currentViewID: currentViewID,
            columns: JSON.stringify(columns),
        })
        .done(function (data) {
            $('#layoutColumns').modal('hide')
        });

}


function loadView() {
    var preradio = $("#idradio").find(":selected").attr("data-preradio"); // channel
    var dbtable = $("#database").val();
    let currentViewID = $('#view').val();

    $.post('get_content.php?loadView', {
            preradio: preradio,
            dbtable: dbtable,
            currentViewID: currentViewID,
            prevViewID: prevViewID,
        })
        .done(function (data) {
            if (data == 'correct') {
                prevViewID = currentViewID;
                loadTable();
            }
        });
}



function saveViewForm() {
    var title = "Elimina Vista";

    var content = "<div style='width: 100%; float: left; text-align: center; font-weight: 700; margin-top: 1vw; color: black; font-size: 1.5vw'></div>";
    content += "<div style='width: 100%; float: left;color: black; font-size: 1vw; margin-top: 1vw;padding: 1vw;'>";
    content += '<input type="text" class="form-control" id="newview" placeholder="Nome vista"></div>';

    content += "<button onclick='saveView()' style='cursor:pointer; width: 10vw; height: 2vw; float: left; text-align: center;  background-color: green; margin-left: 20%; margin-top: 3vw; border: none; font-size: 0.9vw; color: white; border-radius: 0.5vw;'>Save</button>";
    content += "<button onclick='closeWindow()' style='cursor:pointer; width: 10vw; height: 2vw; float: right; text-align: center; background-color: #5e5e5e; margin-right: 20%; margin-top: 3vw; border: none; font-size: 0.9vw; color: white; border-radius: 0.5vw;'>Cancel</button>";

    openEditWindow(title, content);
}

// add new view in db
function saveView() {
    var preradio = $("#idradio").find(":selected").attr("data-preradio"); // channel
    var dbtable = $("#database").val();
    let nameView = $('#newview').val();

    if (nameView == '') {
        closeWindow()
        return
    }

    $.post('get_content.php?saveView', {
            preradio: preradio,
            dbtable: dbtable,
            prevViewID: prevViewID,
            nameView: nameView,
            tableSetup: JSON.stringify(tableSetup),
        })
        .done(function (data) {
            if (data = 'correct') {
                alert('View added')
                loadTable();
                closeWindow()
            }
        });
}



function deleteViewForm() {
    let currentViewID = $('#view').val();
    var title = "Elimina Vista";

    var content = "<div style='width: 100%; float: left;color: black; font-size: 1vw; margin-top: 1vw;padding: 1vw; font-size: 6vw'>";
    content += '<select class="form-control" style="font-size: 1vw"  id="deleteView">';

    $("#view option").each(function () {
        if (this.text != 'Default') {
            if (this.value == currentViewID) content += `<option value="${this.value}" selected>` + this.text + '</option>';
            else content += `<option value="${this.value}">` + this.text + '</option>';
        }
    });
    content += '</select></div>';

    content += "<button onclick='deleteView()' style='cursor:pointer; width: 10vw; height: 2vw; float: left; text-align: center; background-color: red; margin-left: 20%; margin-top: 3vw; border: none; font-size: 0.9vw; color: white; border-radius: 0.5vw;'>Delete</button>";
    content += "<button onclick='closeWindow()' style='cursor:pointer; width: 10vw; height: 2vw; float: right; text-align: center; background-color: #5e5e5e; margin-right: 20%; margin-top: 3vw; border: none; font-size: 0.9vw; color: white; border-radius: 0.5vw;'>Cancel</button>";

    openEditWindow(title, content);
}

function deleteView() {

    var preradio = $("#idradio").find(":selected").attr("data-preradio"); // channel
    var dbtable = $("#database").val();
    let view = $('#deleteView').val();
    let currentViewID = $('#view').val();

    $.post('get_content.php?deleteView', {
            preradio: preradio,
            dbtable: dbtable,
            view: view,
            currentViewID: currentViewID,
        })
        .done(function (data) {
            if (data == 'correct') {
                closeWindow()
                alert('View deleted');
                if (currentViewID == view) {
                    loadTable();
                } else {
                    $(`#view option[value='${view}']`).remove();
                    $('#view').val(currentViewID);
                }
            }
        });

}




function timeFormatter(s) {

    // Pad to 2 or 3 digits, default is 2
    function pad(n, z) {
        z = z || 2;
        return ('00' + n).slice(-z);

    }

    var ms = s % 1000;
    s = (s - ms) / 1000;
    var secs = s % 60;
    s = (s - secs) / 60;
    var mins = s % 60;
    var hrs = (s - mins) / 60;


    let h = ''
    let m = ''
    let ss = ''


    h = (hrs == 0) ? '' : hrs

    if (hrs != 0) {
        m = (mins < 10) ? ':0' + mins : ':' + mins
    } else {
        m = (mins == 0) ? '' : mins
    }

    if (mins != 0) {
        ss = (secs < 10) ? ':0' + secs + '.' + pad(ms, 3) : ':' + secs + '.' + pad(ms, 3)
    } else {
        ss = (secs == 0) ? '' : secs + '.' + pad(ms, 3)
    }

    return h + m + ss

}




function nameFormatter(value, type, row, index) {
    var table = $('#mediamanager_table').DataTable()
    let field = table.column(index['col']).header().innerHTML

    let val = ''
    switch (field) {

        case 'ForceField':
            switch (value) {
                case '0':
                    val = 'Automatic';
                    break;
                case '1':
                    val = 'First Field 1';
                    break;
                case '2':
                    val = 'First Field 2';
                    break;
                case '3':
                    val = 'Progressive';
                    break;
            }
            break;

        case 'KeepAspect':
            switch (value) {
                case '0':
                    val = 'Default';
                    break;
                case '1':
                    val = 'None';
                    break;
                case '2':
                    val = 'Letter Box';
                    break;
                case '3':
                    val = 'Crop';
                    break;
            }
            break;

        case 'ExecutionMode':
            switch (value) {
                case '0':
                    val = 'Default';
                    break;
                case '1':
                    val = 'Liner:Intro';
                    break;
                case '2':
                    val = 'Liner:Begin or Intro';
                    break;
                case '3':
                    val = 'Liner:Begin or Intro without overwrite';
                    break;
                case '4':
                    val = 'Liner:Intro without overwrite';
                    break;
                case '5':
                    val = 'Voice Over';
                    break;
                case '6':
                    val = 'Auto Voice Over';
                    break;
                case '7':
                    val = 'Use as background';
                    break;
            }
            break;


        case 'ValidHoursWeeklyMonday':
        case 'ValidHoursWeeklyTuesday':
        case 'ValidHoursWeeklyWednwsday':
        case 'ValidHoursWeeklyThursday':
        case 'ValidHoursWeeklyFriday':
        case 'ValidHoursWeeklySaturday':
        case 'ValidHoursWeeklySunday':
            if (!value.includes('0')) {
                val = 'All Day'
            } else {
                let hours = '';
                for (i = 0; i < 24; i++) {
                    if (value[i] == 1) hours += i + " ";
                }
                val = hours
            }

            break;

        case 'ValidMonths':
            if (!value.includes('0')) {
                val = 'All Year'
            } else {
                let months = '';
                for (i = 1; i < 13; i++) {
                    if (value[i - 1] == 1) months += i + " ";
                }
                val = months
            }
            break;
    }


    return val

}

function datetimeFormatter(value) {
    if ((new Date(value) !== "Invalid Date") && !isNaN(new Date(value)))
        return value

    return ""
}


function checkboxFormatter(value) {
    if (value == 1) return '<input type="checkbox" checked onclick="return false">';
    return '<input type="checkbox" onclick="return false">';
}

function slist() {
    let items = document.getElementsByClassName('column'),
        current = null;

    // (B) MAKE ITEMS DRAGGABLE + SORTABLE
    for (let i of items) {
        // (B1) ATTACH DRAGGABLE
        i.draggable = true;

        // (B2) DRAG START - YELLOW HIGHLIGHT DROPZONES
        i.ondragstart = (ev) => {
            ev.dataTransfer.setData("text", ev.target.id);
            current = i;
        };

        // (B6) DRAG OVER - PREVENT THE DEFAULT "DROP", SO WE CAN DO OUR OWN
        i.ondragover = (evt) => {
            evt.preventDefault();
        };

        // (B7) ON DROP - DO SOMETHING
        i.ondrop = (evt) => {
            evt.preventDefault();

            if (i != current) {
                let currentpos = 0,
                    droppedpos = 0;
                for (let it = 0; it < items.length; it++) {
                    if (current == items[it]) {
                        currentpos = it;
                    }
                    if (i == items[it]) {
                        droppedpos = it;
                    }
                }
                if (currentpos < droppedpos) {
                    i.parentNode.insertBefore(current, i.nextSibling);
                } else {
                    i.parentNode.insertBefore(current, i);
                }
            }

            // ordinamento alfabetico
            $("#disabled_columns div").sort(Ascending_sort).appendTo('#disabled_columns');

        };
    }
}

function allowDrop(event) {
    event.preventDefault() // allow a drop
}

function drop(ev) {
    ev.preventDefault();
    var data = ev.dataTransfer.getData("text");
    if (ev.target.id == 'disabled_columns' || ev.target.id == 'enabled_columns') ev.target.appendChild(document.getElementById(data));
}

function Ascending_sort(a, b) {
    return ($(b).attr("value").toUpperCase()) < ($(a).attr("value").toUpperCase()) ? 1 : -1;
}


function openEditWindow(title, content) {
    document.getElementById("editWindowTitle").innerHTML = title;
    document.getElementById("editWindowContent").innerHTML = content;
    $("#editWindow").fadeIn(200);
}

function closeWindow() {
    $("#editWindow").fadeOut(200);
    document.getElementById("editWindowTitle").innerHTML = "";
    document.getElementById("editWindowContent").innerHTML = "";
}



function Hex(num) {
    // map for decimal to hexa, 0-9 are
    // straightforward, alphabets a-f used
    // for 10 to 15.

    let m = new Map();

    let digit = '0'.charCodeAt(0); // returns the Unicode of the character
    let c = 'a'.charCodeAt(0);

    //16
    for (let i = 0; i <= 15; i++) {
        if (i < 10) {
            m.set(i, String.fromCharCode(digit));
            digit++;
        } else {
            m.set(i, String.fromCharCode(c));
            c++;
        }
    }

    // string to be returned
    let res = "";

    // check if num is 0 and directly return "0"
    if (num == 0) {
        return "0";
    }
    // if num>0, use normal technique as
    // discussed in other post
    if (num > 0) {
        while (num != 0) {
            res = m.get(num % 16) + res;
            num = Math.floor(num / 16);
        }
    }

    // if num<0, we need to use the elaborated
    // trick above, lets see this
    else {
        // store num in a u_int, size of u_it is greater,
        // it will be positive since msb is 0
        let n = num + Math.pow(2, 32); // esponeniale

        // use the same remainder technique.
        let i = 0;
        while (n != 0 && i < 6) {
            res = m.get(n % 16) + res;
            n = Math.floor(n / 16); // arrotonda
            i++;
        }
    }

    //return res;
    let color = `#${res}`;
    const r = parseInt(color.slice(1, 3), 16);
    const g = parseInt(color.slice(3, 5), 16);
    const b = parseInt(color.slice(5, 7), 16);

    return `rgb(${r}, ${g}, ${b})`;
}



//PLAYER
var isCarambolaPlayerActive = false;
var carambolaPlayerInterval;

function carambolaPlayer(path, name, url) {

    //console.log(url)

    if (path == "" || path == null) {

        return false;
    }

   

    document.getElementById('carambolaPlayerCurrentTime').innerHTML = "00:00:00";

    var extension = path.split('.').pop();

    if (extension != "mp3" && extension != "wav" && extension != "aud") {}

    carambolaPlayerInterval = setInterval(function () {

        carambolaPlayerUpdateStatus();

    }, 500);


    document.getElementById('actualAudioPlayer').src = "getAudioData.php?path=" + path;

    document.getElementById('audioPlayerOBJ').load();

    document.getElementById('audioPlayerOBJ').play();

    document.getElementById('carambolaPlayerTitle').innerHTML = "<marquee>" + url + "</marquee>";

    $('#carambolaPlayer').fadeIn(100);

    isCarambolaPlayerActive = true;

}


function carambolaPlayerUpdateStatus() {

    if (document.getElementById('audioPlayerOBJ').readyState == 0) return false;

    if (document.getElementById('audioPlayerOBJ').paused && document.getElementById('audioPlayerOBJ').duration == document.getElementById('audioPlayerOBJ').currentTime) {
        document.getElementById('carambolaPlayerStatusImg').src = '../ui/playbutton.png';
        document.getElementById('audioPlayerOBJ').currentTime = 0;
    }

    var duration_total = document.getElementById('audioPlayerOBJ').duration;
    var currentTime = document.getElementById('audioPlayerOBJ').currentTime;

    var progress = (100 / duration_total) * currentTime;
    document.getElementById('carambolaPlayerProgressbar').style.width = progress + "%";

    var currentTime_parsed = ms_to_hhmmss(currentTime * 1000);
    var duration_total_parsed = ms_to_hhmmss(duration_total * 1000);

    document.getElementById('carambolaPlayerCurrentTime').innerHTML = currentTime_parsed;
    document.getElementById('carambolaPlayerTotalTime').innerHTML = duration_total_parsed;


}

function carambolaPlayerLocate(e, obj) {

    if (document.getElementById('actualAudioPlayer').src == undefined)
        return false;

    var offsetX = e.offsetX;
    var width = $('#' + obj.id).width();

    var percentage_location = (100 / width) * offsetX;
    var duration_total = document.getElementById('audioPlayerOBJ').duration;
    var time_location = (duration_total / 100) * percentage_location;
    document.getElementById('audioPlayerOBJ').currentTime = time_location;
    carambolaPlayerUpdateStatus();
}


function carambolaPlayerPlay() {

    if (!document.getElementById('actualAudioPlayer').src) return false;

    if (!document.getElementById('audioPlayerOBJ').paused && document.getElementById('audioPlayerOBJ').duration > 0) {
        document.getElementById('carambolaPlayerStatusImg').src = '../ui/playbutton.png';
        document.getElementById('audioPlayerOBJ').pause();
    } else {
        document.getElementById('carambolaPlayerStatusImg').src = '../ui/pausebutton.png';
        document.getElementById('audioPlayerOBJ').play();
    }

}

function closeCarambolaPlayer() {

    isCarambolaPlayerActive = false;
    if (document.getElementById('actualAudioPlayer') != null)
        document.getElementById('actualAudioPlayer').src = "";

    if (document.getElementById('audioPlayerOBJ') != null)
        document.getElementById('audioPlayerOBJ').pause();

    $('#carambolaPlayer').fadeOut(100);
    clearTimeout(carambolaPlayerInterval);

}


function ms_to_hhmmss(ms_part) {

    var duration = "";
    var sec_len = parseInt(ms_part / 1000);
    var actual_sec = sec_len % 60;
    var mins_len = sec_len / 60;
    var actual_mins = mins_len % 60;
    var hours_len = parseInt(mins_len / 60);

    if (hours_len >= 10) {
        if (hours_len >= 24) {

            hours_len -= 24;

            if (hours_len < 10)
                duration += "0" + parseInt(hours_len) + ":";
            else
                duration += parseInt(hours_len) + ":";
        } else
            duration += parseInt(hours_len) + ":";
    } else
        duration += "0" + parseInt(hours_len) + ":";

    if (actual_mins >= 10)
        duration += parseInt(actual_mins) + ":";
    else
        duration += "0" + parseInt(actual_mins) + ":";

    if (actual_sec >= 10)
        duration += parseInt(actual_sec);
    else
        duration += "0" + parseInt(actual_sec);

    return duration;
}